/*<buf>
   <copyright year = 2004-2005>
      <company = 'Gentee, Inc.'  url = 'http://www.gentee.com'  email = info@gentee.com >
      <author = 'Alexey Krivonogov'>
      <file>
This file is part of the Gentee STDLIB library.
      </>
   </>
   <desc>
   </>
</>*/

/*
type buf < index = byte > {
   uint  data < free >
   uint  use     //   
   uint  size    //   
   uint  step    //      
}
*/
method buf.free()
{
   //     free 
   free( this.data )
   this.data = 0
   this.use = 0
   this.size = 0
} 

method buf.clear()
{
   this.use = 0
} 

method uint buf.index( uint i )
{
//   if i < this.use : 
   return this.data + i
//   return 0
}

method uint buf.ptr
{
   return this.data
}

method buf buf.alloc( uint size )
{
   if this.data : free( this.data )

   this.data = alloc( size )
   this.size = size
   this.use = 0

   return this
}

//        
method buf buf.array( uint i )
{
   this.alloc( i )
   mzero( this.data, i )
   this.use = i;
   return this
}

method buf buf.expand( uint size )
{
/*   if size < this.size : return this

   uint   old = this.data
   uint   use = this.use

   if !this.step { this.step = max( size/2, 32 ) }
   else
   { if this.step < this.size / 2 : this.step = this.size / 2 }
   
   if size < this.size + this.step : size = this.size + this.step 

   this.data = 0
   this.alloc( size )
   if old
   {
      mcopy( this.data, old, use )
      this.use = use
      free( old )
   }

   return this*/
   if size <= this.size : return this

   uint   tmp
   uint   old = this.data
   uint   use = this.use

   if !this.step { this.step = max( size/2, 32 ) }
   else
   { if this.step < this.size / 2 : this.step = this.size / 2 }
   
   tmp = this.size + this.step
   if size < tmp : size = tmp

   this.data = 0
   this.alloc( size )
   if old
   {
      mcopy( this.data, old, use )
      this.use = use
      free( old )
   }

   return this
}

method buf buf.copy( uint src size )
{
   this.use = 0
   this.expand( size + 1 )
   mcopy( this.data, src, size )
   this.use = size
   
   return this
}

method buf buf.append( uint src size )
{
   this.expand( this.use + size + 1 )
   mcopy( this.data + this.use, src, size )
   this.use += size
   
   return this
}

operator buf =( buf left right )
{
   return left.copy( right.data, right.use )
}

operator buf +=( buf left right )
{
   left.expand( left.use + right.use )
   mcopy( left.data + left.use, right.data, right.use )
   left.use += right.use

   return left
}

operator buf +( buf left right result )
{
   result = left
   return result += right
}

operator uint ==( buf left right )
{
   if left.use != right.use : return 0
   return !mcmp( left.data, right.data, left.use )
}

operator uint <( buf left right )
{
   uint size = ?( left.use < right.use, left.use, right.use )

   if mcmp( left.data, right.data, size ) < 0 : return 1

   return ?( size > left.use, 1, 0 )
}

operator uint >( buf left right )
{
   uint size = ?( left.use < right.use, left.use, right.use )

   if mcmp( left.data, right.data, size ) > 0 : return 1

   return ?( size < left.use, 1, 0 )
}

operator uint *( buf left )
{
   return left.use
}
 
operator buf +=( buf left, byte val )
{
   left.expand( left.use + 1 )
   ( left.data + left.use )->byte = uint( val )
   left.use++
   return left
}

operator buf +=( buf left, sbyte val )
{
   left.expand( left.use + 1 )
   ( left.data + left.use )->sbyte = int( val )
   left.use++
   return left
}

operator buf +=( buf left, ushort val )
{
   left.expand( left.use + 2 )
   ( left.data + left.use )->ushort = uint( val )
   left.use += 2
   return left
}

operator buf +=( buf left, short val )
{
   left.expand( left.use + 2 )
   ( left.data + left.use )->short = int( val )
   left.use += 2
   return left
}

operator buf +=( buf left, uint val )
{
   left.expand( left.use + 4 )
   ( left.data + left.use )->uint = val
   left.use += 4
   return left
}

operator buf +=( buf left, int val )
{
   left.expand( left.use + 4 )
   ( left.data + left.use )->int = val
   left.use += 4
   return left
}

operator buf +=( buf left, long val )
{
   left.expand( left.use + 8 )
   ( left.data + left.use )->long = val
   left.use += 8
   return left
}

operator buf +=( buf left, ulong val )
{
   left.expand( left.use + 8 )
   ( left.data + left.use )->ulong = val
   left.use += 8
   return left
}

method buf uint.buf( buf result )
{
   result.free()
   return result += this   
}

method buf int.buf( buf result )
{
   result.free()
   return result += this   
}

method buf.del( uint off size )
{
/*   if !size : return
   
   uint  use = *this

   off = min( off, use )
   size = min( use - off, size )

   mmove( this.data + off, this.data + off + size, use - size - off )
   this.use -= size*/

   if !size || off > this.use : return
   
//   uint  use = *this

//   off = min( off, use )
//   size = min( use - off, size )
   uint tmp = this.use - off
   if size >tmp : size = tmp

   mmove( this.data + off, this.data + off + size, tmp - size )
   this.use -= size
}

method buf  buf.replace( uint offset size, buf value )
{                        
   if  offset >= *this : return this += value
   
   if  offset + size > *this : size = *this - offset

   uint len = *value
   int  dif = len - size
   uint end = offset + size
   
   if dif < 0 : this.del( end - uint( -dif ), uint( -dif ))
   if dif > 0 
   {
      this.expand( *this + len )
      mmove( this.data + end + dif, 
              this.data + end, this.use - end )
      this.use += dif   
   }
   mcopy( this.data + offset, value.data, len )

   return this
}

method buf  buf.insert( uint offset, buf value )
{
   return this.replace( offset, 0, value )
}

method uint buf.crc
{
   return crc( this.data, this.use, 0xFFFFFFFF )
}

method buf buf.align
{
   reserved zero[4]
   
   if this.use & 3 
   {
      this.append( &zero, 4 - ( this.use & 3 ))
   }
   return this
}
