/*<arr>
   <copyright year = 2004-2005>
      <company = 'Gentee, Inc.'  url = 'http://www.gentee.com'  email = info@gentee.com >
      <author = 'Alexey Krivonogov'>
      <file>
This file is part of the Gentee STDLIB library.
      </>
   </>
   <desc>
   </>
</>*/


type arr {
   buf   abuf  
   uint  itype    //   
   uint  isize    //   
   uint  dim < xdim >      //   
   uint  cur               //    foreach
}

method arr arr.init()
{
   this.itype = uint
   this.isize = sizeof( uint )
   return this
} 
/*
method arr.setincrement( uint step )
{
   this.abuf.step = step
}
*/
method uint arr.ptr
{
   return this.abuf.ptr()
}

operator uint *( arr left )
{
   return left.abuf.use / left.isize
}

method arr arr.sort( uint sortfunc )
{
   idvm iv
   
   sort( this.ptr(), *this, this.isize, &setidvm( iv, sortfunc ))
   return this
} 

method arr.delete()
{
   uint data = this.abuf.data
   uint i 
   uint count = *this
   uint itype = this.itype
    
   if type_hasdel( itype )
   {
      fornum i, count
      {
         type_delete( data, itype )
         data += this.isize         
      }       
   }
   this.abuf.use = 0
} 

method arr.clear()
{
   this.delete()
} 

//        
method arr arr.array( uint count )
{
   uint i itype = this.itype, data 
   
   this.abuf.alloc( count * this.isize )
   this.abuf.use = count * this.isize 
   data = this.abuf.data 
   if type_hasinit( itype )
   {
      fornum i, count
      {
         type_init( data, itype )
         data += this.isize         
      }       
   }
   else : mzero( this.abuf.data, this.abuf.use )

   return this
}

method uint arr.expand( uint count )
{
   uint i itype = this.itype, data size
   
   size = count * this.isize
   this.abuf.expand( this.abuf.use + size )
   data = this.abuf.data + this.abuf.use
   this.abuf.use += size 

   if type_hasinit( itype )
   {
      fornum i, count
      {
         type_init( data, itype )
         data += this.isize         
      }       
   }
   else : mzero( data, size )

   return *this
}

//        
method arr.oftype( uint itype )
{
   this.itype = itype
   this.isize = sizeof( itype )
}

method uint arr.index( uint i )
{                       
   return this.abuf.data + i * this.isize
}

method uint arr.eof()
{
   return ?( this.cur < *this, 0,  1 )   
}

method uint arr.first
{
   this.cur = 0
   return this.index( this.cur )
}

method uint arr.next
{
   return this.index( ++this.cur )
}

method arr arr.reserve( uint count )
{
   this.abuf.expand( count * this.isize )
   return this
}

method arr.del( uint from to )
{
   uint itype = this.itype
   uint i
    
   if from >= *this : return
   if to >= *this : to = *this - 1
  
   if type_hasdel( itype )
   {
      fornum i = from, to + 1
      {
         type_delete( this.index( i ), itype )
      }       
   }
   this.abuf.del( from * this.isize, ( to - from + 1 ) * this.isize )
}

method arr.del( uint num )
{
   this.del( num, num )
}

method arr.cut( uint count )
{
   this.del( count, *this - 1 )
}

method arr.move( uint from to )
{
   buf btemp
   
   if from == to || from >= *this : return   
   
   if to >= *this : to = *this - 1
   
   btemp.copy( this.index( from ), this.isize )
   
   if from > to
   {
      mmove( this.index( to + 1 ), this.index( to ), this.isize * ( from - to ))   }
   else
   {
      mmove( this.index( from ), this.index( from + 1), 
             this.isize * ( to - from ))   
   }
   mcopy( this.index( to ), btemp.ptr(), this.isize )
}

method arr.insert( uint id count )
{
   uint prev size
   buf btemp
   
   if !count : return
   
   prev = *this   
   this.expand( count )

   if id < prev 
   {
      size = this.isize * count
      btemp.copy( this.index( prev ), size )   
      mmove( this.index( id + count ), this.index( id ), this.isize * ( prev  - id ))   
      mcopy( this.index( id ), btemp.ptr(), size )   
   }
}

method arr.insert( uint id )
{
   this.insert( id, 1 )
}

