/*<strfile>
   <copyright year = 2004-2005>
      <company = 'Gentee, Inc.'  url = 'http://www.gentee.com'  email = info@gentee.com >
      <author = 'Alexey Krivonogov'>
      <file>
This file is part of the Gentee STDLIB library (Linux version).
      </>
   </>
   <desc>
   </>
</>*/

method str str.fappendslash
{
   if !this.islast( '/' ) : this.appendch( '/' )

   return this
}

method str str.faddname( str name )
{
   if *this && *name: this.fappendslash()
   
   return this += name
}

method str str.fdelslash
{
   return this.trim( '/', $TRIM_RIGHT )
}

method str str.fgetdir( str name )
{
   uint  len = name.findch( '/', $TRUE )
   
   if len >= *name : len = 0
   if &name == &this : this.setlen( len )
   else : this.substr( name, 0, len )

   return this
}


method str str.ffullname( str name )
{
/*LU   
   uint  off
   buf   curdir
   this.reserve( 512 )
   this.setlen( GetFullPathName( name.ptr(), 512, this.ptr(), &off ))
LU*/
	str curdir
	arr dirs of str
	uint i
	uint dir
	if name[0] == '/'
	{
		curdir = name
	}
	else
	{
		curdir.reserve( 512 )
		if !_getcwd( curdir.ptr(), 512 )
		{
			return this.clear()
		}
		curdir.setlenptr()
		curdir += "/" + name
	}
	curdir.split( dirs, '/', 0 )
	i = 0
	while i < *dirs
	{
		dir = &dirs[i]
		dir as str

		if *dir == 1
		{
			if dir[0] == '.'
			{
				dirs.del(i)
				continue
			}
		}
		elif *dir == 2
		{
			if dir[0] == '.' && dir[1] == '.'
			{
				dirs.del(i)
				if i
				{
					i--
					dirs.del(i)
				}
				continue
			}
		}
		i++
	}
	this.clear()
	foreach a, dirs
	{
		this += "/" + a
	}
   return this
}

method str str.fgetdrive( str name )
{
   uint   i
   
   this.ffullname( name )
   
   if this[ 1 ] == ':'
   {
      i = 2
   }
   elif this[0] == '/' && this[1] == '/'
   {
      i = this.findchnum( '/', 4 )
   }
   this.setlen( i )

   return this.fappendslash()
}

method str.fsplit( str dir name )
{
   uint   separ = this.findch( '/', $TRUE )
   uint   len = *this
   uint   off

   off = ?( separ >= len, 0, separ + 1 )

   name.copy( this.ptr() + off )
   dir.substr( this, 0, ?( separ && separ < len, separ, 0 ))
}

method str str.fnameext( str name )
{
   uint   separ = name.findch( '/', $TRUE )
   uint   off = ?( separ >= *name, 0, separ + 1 )

   return this.copy( name.ptr() + off )
}

//--------------------------------------------------------------------------

method  str.fgetparts( str dir fname ext )
{
   uint   dot = this.findch( '.', $TRUE )
   uint   separ = this.findch( '/', $TRUE )
   uint   off

   if ext
   {
      if ( dot > separ || separ >= *this ) && dot < *this
      {
         ext.substr( this, dot + 1, *this - dot - 1 )
      }
      else : ext.clear()
   }
   if fname
   {
      off = ?( separ >= *this, 0, separ + 1 )
      fname.substr( this, off, dot - off )
   }
   if dir
   {
      dir.substr( this, 0, ?( separ && separ < *this, separ, 0 ))
   }
}

//--------------------------------------------------------------------------

method str str.fsetparts( str dir fname ext )
{
   str  cdir cname cext

   this.fgetparts( cdir, cname, cext )
   this.clear( )

   this = ?( dir, dir, cdir )

   this.faddname( ?( fname, fname, cname ))

   if ext || *cext
   {
      this.appendch( '.' )
      this += ?( ext, ext, cext )
   }
   return this
}

//--------------------------------------------------------------------------

method str str.fsetext( str name ext )
{
   this = name
   this.setlen( this.findch( '.', 1 ))
   if ext : this += ".\(ext)"
   return this
//   return this.fsetparts( 0->str, 0->str, ext )
}

//--------------------------------------------------------------------------

method uint str.fwildcard( str wildcard )
{
   return sfwildcard( this.ptr(), wildcard.ptr())
}

//--------------------------------------------------------------------------

method str str.fsetname( str filename )
{
    return this.fgetdir( this ).faddname( filename )
}

//--------------------------------------------------------------------------
