/*<hash>
   <copyright year = 2004-2005>
      <company = 'Gentee, Inc.'  url = 'http://www.gentee.com'  email = info@gentee.com >
      <author = 'Alexey Krivonogov'>
      <file>
This file is part of the Gentee STDLIB library.
      </>
   </>
   <desc>
   </>
</>*/

type hashkey
{
   str   key   // 
   uint  next  //    
}
// hashkey  

type hkeys< index = str >
{
   uint  owner
}

type hash < index = uint >{
   arr   hashes   //       hashkey
   uint  itype    //   
   uint  isize    //   
   uint  count    //  
   uint  igncase  // 1   
   uint  curind   //    foreach
   uint  curitem  //    foreach
   uint  forkeys  // 1  foreach  
   hkeys keys     //    
}

//        
method hash.oftype( uint itype )
{
   this.itype = itype
   this.isize = sizeof( hashkey ) + sizeof( itype )
}

method uint hash.sethashsize( uint power )
{
   if this.count : return 0
   if power < 8 : power = 8
   if power > 20 : power = 20
   this.hashes.clear()
   this.hashes.expand( 1 << power )
   return 1
}

method hash hash.init()
{
   this.sethashsize( 12 )  // 4096
   this.oftype( uint )
   this.keys.owner = &this
   return this
} 

operator uint *( hash left )
{
   return left.count
}

method uint hash.ignorecase
{
   if this.count : return 0
   this.igncase = 1
   return 1
}

method hash.delete()
{
   uint i
   uint base
   
   fornum i, *this.hashes
   {
      while this.hashes[ i ]
      {
         base = this.hashes[ i ]
         this.hashes[ i ] = base->hashkey.next
         if type_hasdel( this.itype )
         {
            type_delete( base + sizeof( hashkey ), this.itype )
         }      
         type_delete( base, hashkey )
         free( base )
      }
   }
} 

method hash.clear()
{
   this.delete()
   this.count = 0
//   mzero( this.hashes.abuf.data, this.hashes.abuf.use )
}

method uint hash.keyfind( str key, uint index )
{
   uint  i
   
   if this.igncase 
   {
      str lkey = key
      
      lkey.lower()
      i = lkey.crc() & ( *this.hashes - 1 )
   }
   else : i = key.crc() & ( *this.hashes - 1 )
   uint  ptr = this.hashes[ i ]
   
   if index : index->uint = i
   if !ptr : return 0
   while ptr
   {
      if this.igncase 
      {
         if ptr->hashkey.key %== key : break
      }
      elif ptr->hashkey.key == key : break
      ptr = ptr->hashkey.next
   }
   return ?( ptr, ptr + sizeof( hashkey ), 0 )
}

method uint hash.find( str key )
{
   return this.keyfind( key, 0 )
}

method uint hash.create( str key )
{
   uint  index
   uint  item = this.keyfind( key, &index )
   uint  data
   if !item
   {
      data = alloc( this.isize )
      type_init( data, hashkey )
      item = data + sizeof( hashkey )
//      type_init( item, this.itype )
      //  
      data->hashkey.key = key
      data->hashkey.next = this.hashes[ index ]
      this.hashes[ index ] = data
      this.count++
   }
   else
   {
      if type_hasdel( this.itype ) : type_delete( item, this.itype )
//      type_init( item, this.itype )
   }
   type_init( item, this.itype )
   return item   
} 

method uint hash.index( str key )
{
   uint  item = this.find( key )
   
   if !item : return this.create( key )
   return item
}

method uint hash.del( str key )
{
   uint index
   uint ptr
   uint item = this.keyfind( key, &index )
   uint base
   
   if !item : return 0
   //   
   ptr = this.hashes[ index ]
   base = item - sizeof( hashkey )
   if ptr == base
   {
      this.hashes[ index ] = base->hashkey.next
   }
   else
   {
      while ptr->hashkey.next != base
      {
         ptr = ptr->hashkey.next
         if !ptr : return 0
      }
      ptr->hashkey.next = base->hashkey.next
   }
   //     
   if type_hasdel( this.itype )
   {
      type_delete( item, this.itype )
   }      
   type_delete( base, hashkey )
   free( base )
   this.count--
   return 1
}

method uint hash.eof()
{
   return this.curind >= *this.hashes 
}

method uint hash.next
{
   if this.curitem
   {
      if this.curitem = this.curitem->hashkey.next
      {
//         return &this.curitem->hashkey.key
         return ?( this.forkeys, &this.curitem->hashkey.key,
                   this.curitem + sizeof( hashkey ))
      }
      this.curind++
   }      
   while !this.hashes[ this.curind ] && this.curind < *this.hashes 
   {
      this.curind++
   }
   if this.curind < *this.hashes
   {
      this.curitem = this.hashes[ this.curind ]
      return ?( this.forkeys, &this.curitem->hashkey.key,
                this.curitem + sizeof( hashkey ))
//      return &this.curitem->hashkey.key
   }
   return 0
}

method uint hash.forfirst
{
   this.curind = 0
   this.curitem = 0
   return this.next()
}

method uint hash.first
{
   this.forkeys = 0
   return this.forfirst()
}

method uint hkeys.eof
{
   return this.owner->hash.eof()
}

method uint hkeys.next
{
   return this.owner->hash.next()
}

method uint hkeys.first
{
   this.owner->hash.forkeys = 1
   return this.owner->hash.forfirst()
}
