/*<collection>
   <copyright year = 2004-2005>
      <company = 'Gentee, Inc.'  url = 'http://www.gentee.com'  email = info@gentee.com >
      <author = 'Alexey Krivonogov'>
      <file>
This file is part of the Gentee STDLIB library.
      </>
   </>
   <desc>
   </>
</>*/

/*
type collection
{
   buf   cbuf    //  
   uint  count   //  
   uint  cnum    //   
   uint  cptr    //   
}
*/

operator uint *( collection left )
{
   return left.count
}

method uint collection.get( uint index )
{
   uint  i

   if index >= this.count : return 0
   
   if index < this.cnum
   {
      this.cnum = 0
      this.cptr = 0
   }
   fornum i = this.cnum, index
   {
      switch ( this.cbuf.data + this.cptr )->uint
      {
         case double, ulong, long
         {
            this.cptr += 4    
         }
      }
//      this.cptr += sizeof( ( this.cbuf.data + this.cptr )->uint ) + 4 
      // 4 - sizeof( uint )    
      this.cptr += 8
   }
   this.cnum = index
   return this.cbuf.data + this.cptr
}

method uint collection.gettype( uint i )
{
   if i < this.count : return this.get( i )->uint
   return 0
}

method uint collection.ptr( uint i )
{
   return this.get( i ) + 4 
}

method uint collection.val( uint i )
{
   uint get = this.get( i )
   
   if get->uint >= long && get->uint <= double : return get + 4
   return ( get + 4 )->uint
}

operator collection =( collection left right )
{
   left.cbuf = right.cbuf
   left.count = right.count
   left.cnum = right.cnum
   left.cptr = right.cptr
   return left
}

method collection collection.append( collection src )
{
   this.cbuf += src.cbuf
   this.count += src.count
   return this
}

method collection collection.clear
{
   this.cbuf.clear()
   this.count = 0
   this.cnum = 0
   this.cptr = 0
   return this
}
