package demo.swing;

import java.awt.Color;
import java.awt.Font;

import javax.swing.UIDefaults;
import javax.swing.plaf.metal.MetalLookAndFeel;

/**
 * 
 * @author MAbernethy
 */
public class FlightLookAndFeel extends MetalLookAndFeel
{
	public UIDefaults getDefaults() 
	{
		UIDefaults def = super.getDefaults();
		Font font = new Font("Courier", Font.PLAIN, 12);
		def.put("Button.font", font);
		def.put("Table.font", font);
		def.put("Label.font", font);
		def.put("ComboBox.font", font);
		def.put("TextField.font", font);
		def.put("TableHeader.font", font);
		def.put("Label.foreground", Color.GREEN);
		
		return def;
	}
	
	public String getDescription()
	{
		return "The Flight Look And Feel is for the Intermediate Swing tutorial";
	}
	
	public String getID()
	{
		return "FlightLookAndFeel 1.0";
	}
	
	public String getName()
	{
		return "FlightLookAndFeel";
	}
	
	public boolean isNativeLookAndFeel()
	{
		return true;
	}
	
	public boolean isSupportedLookAndFeel()
	{
		return true;
	}

}
