package demo.swing;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/**
 * 
 * @author MAbernethy
 */
public class DataHandler
{
	private static List records;
	
	public static List getCities()
	{
		List l = new ArrayList();
		l.add("AUS");
		l.add("ORD");
		l.add("IAH");
		l.add("SFO");
		l.add("DTW");
		l.add("DFW");
		l.add("PHL");
		l.add("ORL");
		l.add("LAS");
		return l;
	}
	
	public static List searchRecords(String depart, String dest)
	{
		if (records == null)
			initRecords();
		List l = new ArrayList();
		Flight f = new Flight();
		f.setDestination(dest);
		f.setDeparture(depart);
		for (Iterator i=records.iterator(); i.hasNext();)
		{
			Flight flight = (Flight)i.next();
			if (flight.getDeparture().equals(f.getDeparture()) 
			    && flight.getDestination().equals(f.getDestination()))
				l.add(flight);
		}		
		return l;
	}
	
	public static void updateRecords(Object o, int tixx) throws Exception
	{
		if (records == null)
			initRecords();
		Flight f = (Flight)o;
		for (int i=0; i<records.size(); i++)
		{
			Flight flight = (Flight)records.get(i);
			if (flight.equals(f))
			{
				if (tixx > flight.getRemainingTixx())
					throw new Exception("Not enough tickets available");
				flight.setRemainingTixx(flight.getRemainingTixx()-tixx);
				records.set(i, flight);
				return;
			}
		}				
	}
	
	private static void initRecords()
	{
		records = new ArrayList();
		
		List l = getCities();
		
		for (int i=0; i<100; i++)
		{
			Flight f = new Flight();
			f.setDeparture(l.get((int)(Math.random()*l.size())).toString());
			f.setDestination(l.get((int)(Math.random()*l.size())).toString());
			f.setRemainingTixx((int)(Math.random()*50));
			f.setFlightNum((int)(Math.random()*9999));
			records.add(f);
		}		
	}
	
	
}
